/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.mozarellabytes.kroy.Entities.FireTruck;
import com.mozarellabytes.kroy.Entities.Fortress;
import java.util.Random;

public class Bomb
extends Sprite {
    private final FireTruck target;
    private final Vector2 truckPosition;
    private final Vector2 startPosition;
    private Vector2 currentPosition;
    private final Vector2 targetPosition;
    private final float damage;

    public Bomb(Fortress fortress, FireTruck target, boolean isRandom) {
        this.target = target;
        this.truckPosition = new Vector2(this.getMiddleOfTile(target.getPosition()));
        this.currentPosition = this.startPosition = new Vector2(fortress.getPosition());
        this.targetPosition = isRandom ? this.getMiddleOfTile(this.generateBombTarget()) : this.getMiddleOfTile(this.truckPosition);
        this.damage = fortress.getFortressType().getAP();
    }

    public boolean checkHit() {
        return this.targetPosition.equals(this.truckPosition) && this.getMiddleOfTile(this.currentPosition).equals(this.truckPosition);
    }

    public boolean hasReachedTargetTile() {
        return (int)this.currentPosition.x == (int)this.targetPosition.x && (int)this.currentPosition.y == (int)this.targetPosition.y;
    }

    public void updatePosition() {
        this.currentPosition = this.startPosition.interpolate(this.targetPosition, 0.03f, (Interpolation)Interpolation.pow5Out);
    }

    private Vector2 getMiddleOfTile(Vector2 position) {
        return new Vector2((float)((int)position.x) + 0.5f, (float)((int)position.y) + 0.5f);
    }

    public void damageTruck() {
        this.target.fortressDamage(this.damage);
    }

    private Vector2 generateBombTarget() {
        float xCoord = (int)(Math.random() * (double)(this.truckPosition.x + 1.0f - (this.truckPosition.x - 1.0f) + 1.0f));
        float yCoord = (int)(Math.random() * (double)(this.truckPosition.y + 1.0f - (this.truckPosition.y - 1.0f) + 1.0f));
        Vector2 positionNearTruck = new Vector2(this.truckPosition.x - 1.0f + xCoord, this.truckPosition.y - 1.0f + yCoord);
        return new Random().nextBoolean() ? this.truckPosition : positionNearTruck;
    }

    public void drawBomb(ShapeRenderer shapeMapRenderer) {
        shapeMapRenderer.setColor(Color.RED);
        shapeMapRenderer.circle(this.currentPosition.x, this.currentPosition.y, 0.2f, 40);
        shapeMapRenderer.setColor(Color.WHITE);
    }
}

