/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.mozarellabytes.kroy.Entities.FireTruck;
import com.mozarellabytes.kroy.Utilities.SoundFX;
import java.util.ArrayList;

public class FireStation {
    private final int x;
    private final int y;
    private final Vector2 spawnTile;
    private final Vector2 bayTile1;
    private final Vector2 bayTile2;
    private final Texture texture;
    private final ArrayList<FireTruck> trucks;

    public FireStation(int x, int y) {
        this.x = x;
        this.y = y;
        this.spawnTile = new Vector2(x + 3, y);
        this.bayTile1 = new Vector2(x + 1, y);
        this.bayTile2 = new Vector2(x + 2, y);
        this.texture = new Texture(Gdx.files.internal("sprites/station/station.png"));
        this.trucks = new ArrayList();
    }

    public void spawn(FireTruck truck) {
        if (SoundFX.music_enabled) {
            SoundFX.sfx_truck_spawn.play();
        }
        this.trucks.add(truck);
    }

    public void restoreTrucks() {
        for (FireTruck truck : this.trucks) {
            if (!truck.getPosition().equals(this.bayTile1) && !truck.getPosition().equals(this.bayTile2)) continue;
            this.repair(truck);
            this.refill(truck);
        }
    }

    private void refill(FireTruck truck) {
        if (truck.getReserve() < truck.type.getMaxReserve()) {
            truck.refill(Math.min(0.06f, truck.getType().getMaxReserve() - truck.getReserve()));
        }
    }

    private void repair(FireTruck truck) {
        if (truck.getHP() < truck.type.getMaxHP()) {
            truck.repair(Math.min(0.04f, truck.getType().getMaxHP() - truck.getHP()));
        }
    }

    public void destroyTruck(FireTruck truck) {
        this.trucks.remove(truck);
    }

    public void checkForCollisions() {
        for (FireTruck truck : this.trucks) {
            for (FireTruck truck2 : this.trucks) {
                if (truck.equals(truck2) || truck.trailPath.isEmpty() || truck.getPosition().equals(this.spawnTile)) continue;
                Vector2 truck2tile = new Vector2(Math.round(truck2.getPosition().x), Math.round(truck2.getPosition().y));
                Vector2 truckstile = new Vector2((float)Math.floor(truck2.getPosition().x), (float)Math.floor(truck2.getPosition().y));
                if (!truck2.trailPath.isEmpty() && truck.trailPath.first().equals(truck2.trailPath.first())) {
                    truck.setCollision();
                    truck2.setCollision();
                    this.resetTruck(truck, truck2);
                    continue;
                }
                if (truck.trailPath.first().equals(truck2tile)) {
                    this.resetTruck(truck, truck2);
                    truck.trailPath.clear();
                    truck2.trailPath.clear();
                    continue;
                }
                if (!truck.trailPath.first().equals(truckstile)) continue;
                this.resetTruck(truck, truck2);
            }
        }
    }

    private void resetTruck(FireTruck truck, FireTruck truck2) {
        if (SoundFX.music_enabled) {
            SoundFX.sfx_horn.play();
        }
        Vector2 hold = truck.trailPath.first();
        truck.resetPath();
        truck.addTileToPath(truck.getPosition());
        truck.addTileToPath(new Vector2((float)Math.floor(truck.getX()), (float)Math.floor(truck.getY())));
        truck2.resetPath();
        truck2.addTileToPath(truck2.getPosition());
        truck2.addTileToPath(hold);
    }

    public void draw(Batch mapBatch) {
        mapBatch.draw(this.texture, (float)this.x, (float)this.y, 5.0f, 3.0f);
    }

    public ArrayList<FireTruck> getTrucks() {
        return this.trucks;
    }

    public FireTruck getTruck(int i) {
        return this.trucks.get(i);
    }
}

