/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Queue;
import com.mozarellabytes.kroy.Entities.FireTruckType;
import com.mozarellabytes.kroy.Entities.Fortress;
import com.mozarellabytes.kroy.Entities.WaterParticle;
import com.mozarellabytes.kroy.Screens.GameScreen;
import com.mozarellabytes.kroy.Utilities.SoundFX;
import java.util.ArrayList;

public class FireTruck
extends Sprite {
    private final GameScreen gameScreen;
    public final FireTruckType type;
    private float HP;
    private float reserve;
    private Vector2 position;
    public final Queue<Vector2> path;
    public final Queue<Vector2> trailPath;
    private boolean moving;
    private boolean attacking;
    private boolean inCollision;
    private Vector2 previousTile;
    private long timeOfLastAttack;
    private final ArrayList<WaterParticle> spray;
    private final Texture lookLeft;
    private final Texture lookRight;
    private final Texture lookUp;
    private final Texture lookDown;

    public FireTruck(GameScreen gameScreen, Vector2 position, FireTruckType type) {
        super(new Texture(Gdx.files.internal("sprites/firetruck/down.png")));
        this.gameScreen = gameScreen;
        this.type = type;
        this.HP = type.getMaxHP();
        this.reserve = type.getMaxReserve();
        this.position = position;
        this.path = new Queue();
        this.trailPath = new Queue();
        this.moving = false;
        this.attacking = false;
        this.inCollision = false;
        this.spray = new ArrayList();
        this.timeOfLastAttack = System.currentTimeMillis();
        this.lookLeft = new Texture(Gdx.files.internal("sprites/firetruck/left.png"));
        this.lookRight = new Texture(Gdx.files.internal("sprites/firetruck/right.png"));
        this.lookUp = new Texture(Gdx.files.internal("sprites/firetruck/up.png"));
        this.lookDown = new Texture(Gdx.files.internal("sprites/firetruck/down.png"));
    }

    public void move() {
        if (this.moving) {
            if (this.path.size > 0) {
                Vector2 nextTile;
                this.position = nextTile = this.path.first();
                if (!this.trailPath.isEmpty() && (float)((int)this.position.x) == this.trailPath.first().x && (float)((int)this.position.y) == this.trailPath.first().y) {
                    this.trailPath.removeFirst();
                }
                if (!this.inCollision) {
                    this.changeSprite(nextTile);
                }
                this.previousTile = nextTile;
                this.path.removeFirst();
            } else {
                this.moving = false;
            }
            if (this.path.isEmpty() && this.inCollision) {
                this.inCollision = false;
            }
        }
    }

    public void repair(float HP) {
        this.HP += HP;
    }

    public void refill(float reserve) {
        this.reserve += reserve;
    }

    public void addTileToPath(Vector2 coordinate) {
        if (this.isValidDraw(coordinate)) {
            if (this.path.size > 0) {
                Vector2 previous = this.path.last();
                int interpolation = (int)(20.0f / this.type.getSpeed());
                for (int i = 1; i < interpolation; ++i) {
                    this.path.addLast(new Vector2((previous.x - coordinate.x) * -1.0f / (float)interpolation * (float)i + previous.x, (previous.y - coordinate.y) * -1.0f / (float)interpolation * (float)i + previous.y));
                }
            }
            this.trailPath.addLast(new Vector2((int)coordinate.x, (int)coordinate.y));
            this.path.addLast(new Vector2((int)coordinate.x, (int)coordinate.y));
        }
    }

    private boolean isValidDraw(Vector2 coordinate) {
        if (coordinate.y < 24.0f && this.gameScreen.isRoad(Math.round(coordinate.x), Math.round(coordinate.y))) {
            if (this.path.isEmpty()) {
                return this.getPosition().equals(coordinate);
            }
            if (!this.path.last().equals(coordinate)) {
                return (int)Math.abs(this.path.last().x - coordinate.x) + (int)Math.abs(this.path.last().y - coordinate.y) <= 1;
            }
        }
        return false;
    }

    private void changeSprite(Vector2 nextTile) {
        if (this.previousTile != null) {
            if (nextTile.x > this.previousTile.x) {
                this.setTexture(this.lookRight);
            } else if (nextTile.x < this.previousTile.x) {
                this.setTexture(this.lookLeft);
            } else if (nextTile.y > this.previousTile.y) {
                this.setTexture(this.lookUp);
            } else if (nextTile.y < this.previousTile.y) {
                this.setTexture(this.lookDown);
            }
        }
    }

    public void resetPath() {
        this.path.clear();
        this.trailPath.clear();
    }

    public void attack(Fortress fortress) {
        if (this.attacking && this.reserve > 0.0f) {
            this.spray.add(new WaterParticle(this, fortress));
            this.reserve -= Math.min(this.reserve, this.type.getAP());
        }
    }

    public boolean fortressInRange(Vector2 fortress) {
        return this.getVisualPosition().dst(fortress) <= this.type.getRange();
    }

    public void updateSpray() {
        if (this.spray != null) {
            for (int i = 0; i < this.spray.size(); ++i) {
                WaterParticle particle = this.spray.get(i);
                particle.updatePosition();
                if (!particle.isHit()) continue;
                this.damage(particle);
                this.removeParticle(particle);
            }
        }
    }

    private void removeParticle(WaterParticle particle) {
        this.spray.remove(particle);
    }

    private void damage(WaterParticle particle) {
        particle.getTarget().damage(Math.min(this.type.getAP(), particle.getTarget().getHP()));
    }

    public void fortressDamage(float HP) {
        if (SoundFX.music_enabled) {
            SoundFX.sfx_truck_damage.play();
        }
        this.HP -= Math.min(HP, this.HP);
    }

    public void drawPath(Batch mapBatch) {
        if (!this.trailPath.isEmpty()) {
            mapBatch.setColor(this.type.getTrailColour());
            for (Vector2 tile : this.trailPath) {
                if (tile.equals(this.trailPath.last())) {
                    mapBatch.draw(this.type.getTrailImageEnd(), tile.x, tile.y, 1.0f, 1.0f);
                }
                mapBatch.draw(this.type.getTrailImage(), tile.x, tile.y, 1.0f, 1.0f);
            }
            mapBatch.setColor(Color.WHITE);
        }
    }

    public void drawStats(ShapeRenderer shapeMapRenderer) {
        shapeMapRenderer.rect(this.getPosition().x + 0.2f, this.getPosition().y + 1.3f, 0.6f, 0.8f, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE);
        shapeMapRenderer.rect(this.getPosition().x + 0.266f, this.getPosition().y + 1.4f, 0.2f, 0.6f, Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE);
        shapeMapRenderer.rect(this.getPosition().x + 0.266f, this.getPosition().y + 1.4f, 0.2f, this.getReserve() / this.type.getMaxReserve() * 0.6f, Color.CYAN, Color.CYAN, Color.CYAN, Color.CYAN);
        shapeMapRenderer.rect(this.getPosition().x + 0.533f, this.getPosition().y + 1.4f, 0.2f, 0.6f, Color.FIREBRICK, Color.FIREBRICK, Color.FIREBRICK, Color.FIREBRICK);
        shapeMapRenderer.rect(this.getPosition().x + 0.533f, this.getPosition().y + 1.4f, 0.2f, this.getHP() / this.type.getMaxHP() * 0.6f, Color.RED, Color.RED, Color.RED, Color.RED);
        for (WaterParticle particle : this.getSpray()) {
            shapeMapRenderer.rect(particle.getPosition().x, particle.getPosition().y, particle.getSize(), particle.getSize(), particle.getColour(), particle.getColour(), particle.getColour(), particle.getColour());
        }
    }

    public void drawSprite(Batch mapBatch) {
        mapBatch.draw(this, this.position.x, this.position.y, 1.0f, 1.0f);
    }

    public Vector2 getVisualPosition() {
        return new Vector2(this.position.x + 0.5f, this.position.y + 0.5f);
    }

    public void setTimeOfLastAttack(long timestamp) {
        this.timeOfLastAttack = timestamp;
    }

    public void setAttacking(boolean b) {
        this.attacking = b;
    }

    public void setMoving(boolean t) {
        this.moving = t;
    }

    public long getTimeOfLastAttack() {
        return this.timeOfLastAttack;
    }

    public float getHP() {
        return this.HP;
    }

    public float getReserve() {
        return this.reserve;
    }

    public FireTruckType getType() {
        return this.type;
    }

    public void setCollision() {
        this.inCollision = true;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Queue<Vector2> getTrailPath() {
        return this.trailPath;
    }

    public Queue<Vector2> getPath() {
        return this.path;
    }

    private ArrayList<WaterParticle> getSpray() {
        return this.spray;
    }

    public boolean getMoving() {
        return this.moving;
    }
}

