/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.mozarellabytes.kroy.Entities.FireTruck;
import com.mozarellabytes.kroy.Entities.Fortress;

public class WaterParticle {
    private final Fortress target;
    private final Color colour;
    private final float size;
    private final Vector2 startPosition;
    private Vector2 currentPosition;
    private Vector2 targetPosition;

    public WaterParticle(FireTruck truck, Fortress target) {
        this.target = target;
        Color[] colors = new Color[]{Color.CYAN, Color.NAVY, Color.BLUE, Color.PURPLE, Color.SKY, Color.TEAL};
        this.colour = colors[(int)(Math.random() * 4.0)];
        this.size = (float)(Math.random() / 5.0 + 0.1);
        this.currentPosition = this.startPosition = new Vector2(truck.getPosition().x + 0.5f, truck.getPosition().y + 0.5f);
        this.targetPosition = target.getPosition();
        this.createTargetPosition(target);
    }

    private void createTargetPosition(Fortress fortress) {
        float xCoord = (float)(Math.random() - 0.5 + (double)fortress.getPosition().x);
        float yCoord = (float)(Math.random() - 0.5 + (double)fortress.getPosition().y);
        this.targetPosition = new Vector2(xCoord, yCoord);
    }

    public void updatePosition() {
        this.currentPosition = this.startPosition.interpolate(this.targetPosition, 0.2f, Interpolation.circle);
    }

    public boolean isHit() {
        return (int)this.targetPosition.x == (int)this.currentPosition.x && (int)this.targetPosition.y == (int)this.currentPosition.y;
    }

    public Fortress getTarget() {
        return this.target;
    }

    public float getSize() {
        return this.size;
    }

    public Color getColour() {
        return this.colour;
    }

    public Vector2 getPosition() {
        return this.currentPosition;
    }
}

