/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.mozarellabytes.kroy.Kroy;
import com.mozarellabytes.kroy.Screens.GameScreen;
import com.mozarellabytes.kroy.Screens.MenuScreen;
import com.mozarellabytes.kroy.Utilities.ControlScreenInputHandler;
import com.mozarellabytes.kroy.Utilities.GUI;
import com.mozarellabytes.kroy.Utilities.GameInputHandler;
import com.mozarellabytes.kroy.Utilities.MenuInputHandler;
import java.awt.Rectangle;

public class ControlsScreen
implements Screen {
    private final Kroy game;
    private Texture backgroundImage;
    private final Texture trailImage;
    private final Texture trailEndImage;
    private final Texture truckRight;
    private final Texture truckLeft;
    private final Texture fortress;
    public final OrthographicCamera camera;
    private final Rectangle exitButton;
    private int HP;
    private int count;
    private final String screen;
    private final float screenWidth;
    private final float screenHeight;
    private final Screen parent;

    public ControlsScreen(Kroy game, Screen parent, String screen) {
        this.game = game;
        this.parent = parent;
        this.screen = screen;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height);
        this.screenWidth = this.camera.viewportWidth;
        this.screenHeight = this.camera.viewportHeight;
        Gdx.input.setInputProcessor(new ControlScreenInputHandler(this));
        if (screen.equals("menu")) {
            this.backgroundImage = new Texture(Gdx.files.internal("menuscreen_blank_2.png"), true);
        } else if (screen.equals("game")) {
            this.backgroundImage = new Texture(Gdx.files.internal("images/YorkMapEdit.png"), true);
        }
        this.backgroundImage.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.trailImage = new Texture(Gdx.files.internal("sprites/firetruck/trail.png"), true);
        this.trailEndImage = new Texture(Gdx.files.internal("sprites/firetruck/trailEnd.png"), true);
        this.truckRight = new Texture(Gdx.files.internal("sprites/firetruck/right.png"), true);
        this.truckLeft = new Texture(Gdx.files.internal("sprites/firetruck/left.png"), true);
        this.fortress = new Texture(Gdx.files.internal("sprites/fortress/fortress.png"), true);
        this.HP = 200;
        this.count = 0;
        this.exitButton = new Rectangle();
        this.exitButton.x = 1185;
        this.exitButton.y = (int)(this.camera.viewportHeight - 90.0f);
        this.exitButton.width = (int)(this.screenWidth / 1.08f);
        this.exitButton.height = (int)(this.screenHeight / 1.126f);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.drawBackgroundImage();
        this.drawFilledBackgroundBox();
        this.game.batch.begin();
        this.game.font50.draw((Batch)this.game.batch, "Control screen", this.screenWidth / 2.8f, this.screenHeight / 1.1678f);
        this.game.font25.draw((Batch)this.game.batch, "Flood the fortresses before the fortresses destroy your fire trucks to win", this.screenWidth / 2.0f - 540.0f, this.screenHeight / 1.29f);
        this.game.font33.draw((Batch)this.game.batch, "Moving the Fire Trucks", this.screenWidth / 8.33f, this.screenHeight * 0.6875f);
        this.game.font25.draw((Batch)this.game.batch, "Click on a truck and drag it", this.screenWidth / 7.692f, this.screenHeight * 0.6125f);
        this.game.font25.draw((Batch)this.game.batch, "This gives the truck a path:", this.screenWidth / 7.692f, this.screenHeight * 0.56875f);
        this.game.font25.draw((Batch)this.game.batch, "Unclick and the truck will", this.screenWidth / 7.692f, this.screenHeight * 0.3815f);
        this.game.font25.draw((Batch)this.game.batch, "follow the path", this.screenWidth / 7.692f, this.screenHeight * 0.34375f);
        this.game.batch.setColor(Color.CYAN);
        float startPos = this.screenWidth / 7.11f;
        float height = this.screenHeight / 2.2857f;
        this.game.batch.draw(this.trailImage, startPos, this.screenHeight / 2.2857f);
        this.game.batch.draw(this.trailImage, startPos + (float)this.trailImage.getWidth() + 2.0f, height);
        this.game.batch.draw(this.trailImage, startPos + (float)(this.trailImage.getWidth() * 2) + 4.0f, height);
        this.game.batch.draw(this.trailImage, startPos + (float)(this.trailImage.getWidth() * 3) + 6.0f, height);
        this.game.batch.draw(this.trailImage, startPos + (float)(this.trailImage.getWidth() * 4) + 8.0f, height);
        this.game.batch.draw(this.trailImage, startPos + (float)(this.trailImage.getWidth() * 5) + 10.0f, height);
        this.game.batch.draw(this.trailImage, startPos + (float)(this.trailImage.getWidth() * 6) + 12.0f, height);
        this.game.batch.draw(this.trailEndImage, startPos + (float)(this.trailImage.getWidth() * 6) + 12.0f, height);
        this.game.font25.draw((Batch)this.game.batch, "Or click and drag from the", this.screenWidth / 7.76f, this.screenHeight / 3.81f);
        this.game.font25.draw((Batch)this.game.batch, "end of the trucks path", this.screenWidth / 7.76f, this.screenHeight / 4.57f);
        this.game.batch.draw(this.trailImage, this.screenWidth / 3.37f, this.screenHeight / 8.89f);
        this.game.batch.draw(this.trailEndImage, this.screenWidth / 3.37f, this.screenHeight / 8.89f);
        this.game.batch.setColor(Color.RED);
        this.game.batch.draw(this.trailImage, this.screenWidth / 4.74f, this.screenHeight / 8.89f);
        this.game.batch.draw(this.trailEndImage, this.screenWidth / 4.74f, this.screenHeight / 8.89f);
        this.game.font33.draw((Batch)this.game.batch, "Attacking the fortresses", this.screenWidth / 1.88f, this.screenHeight * 0.6875f);
        this.game.font25.draw((Batch)this.game.batch, "When a firetruck is within range ", this.screenWidth / 1.87f, this.screenHeight * 0.6125f);
        this.game.font25.draw((Batch)this.game.batch, "of a fortress press A to attack", this.screenWidth / 1.87f, this.screenHeight * 0.56875f);
        this.game.batch.setColor(Color.WHITE);
        this.game.batch.draw(this.truckRight, this.screenWidth / 7.44f, this.screenHeight / 2.33f);
        this.game.batch.draw(this.fortress, this.screenWidth / 1.62f, this.screenHeight / 6.15f);
        this.game.batch.draw(this.truckLeft, this.screenWidth / 1.23f, this.screenHeight / 4.21f);
        this.game.batch.end();
        this.damageFortressHP();
        this.drawFortressHealthBar();
        this.renderExitButton();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.fortress.dispose();
        this.trailImage.dispose();
        this.trailEndImage.dispose();
        this.truckRight.dispose();
        this.truckLeft.dispose();
    }

    public void changeScreen() {
        if (this.screen.equals("game")) {
            GUI gui = new GUI(this.game, (GameScreen)this.parent);
            Gdx.input.setInputProcessor(new GameInputHandler((GameScreen)this.parent, gui));
            gui.idleInfoButton();
            this.game.setScreen(this.parent);
        } else if (this.screen.equals("menu")) {
            Gdx.input.setInputProcessor(new MenuInputHandler((MenuScreen)this.parent));
            this.game.setScreen(this.parent);
        }
    }

    private void drawBackgroundImage() {
        this.game.batch.begin();
        this.game.batch.draw(this.backgroundImage, 0.0f, 0.0f, this.camera.viewportWidth, this.camera.viewportHeight);
        this.game.batch.end();
    }

    private void drawFilledBackgroundBox() {
        this.game.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.game.shapeRenderer.rect(this.screenWidth / 25.6f, this.screenHeight / 16.0f, this.screenWidth / 1.085f, this.screenHeight / 1.14f, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK);
        this.game.shapeRenderer.end();
    }

    private void damageFortressHP() {
        this.HP = this.HP == 0 ? 200 : --this.HP;
    }

    private void drawFortressHealthBar() {
        this.game.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.game.shapeRenderer.rect(this.screenWidth / 1.4713f, this.screenHeight / 2.58f, 35.0f, 60.0f);
        this.game.shapeRenderer.rect(this.screenWidth / 1.4629f, this.screenHeight / 2.5297f, 24.0f, 50.0f, Color.FIREBRICK, Color.FIREBRICK, Color.FIREBRICK, Color.FIREBRICK);
        this.game.shapeRenderer.rect(this.screenWidth / 1.4629f, this.screenHeight / 2.5297f, 24.0f, (float)this.HP / 4.0f, Color.RED, Color.RED, Color.RED, Color.RED);
        this.game.shapeRenderer.end();
        if (this.count <= 30) {
            this.drawFireTruckAttacking();
        } else if (this.count == 60) {
            this.count = 0;
        }
        ++this.count;
    }

    private void drawFireTruckAttacking() {
        this.game.batch.begin();
        this.game.font33.draw((Batch)this.game.batch, "A", this.screenWidth / 1.205f, this.screenHeight / 2.81f);
        this.game.batch.end();
    }

    private void renderExitButton() {
        this.game.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.game.shapeRenderer.rect(this.screenWidth / 1.08f, this.screenHeight / 1.126f, 30.0f, 30.0f, Color.FIREBRICK, Color.FIREBRICK, Color.FIREBRICK, Color.FIREBRICK);
        this.game.shapeRenderer.rect(this.screenWidth / 1.078f, this.screenHeight / 1.123f, 26.0f, 26.0f, Color.RED, Color.RED, Color.RED, Color.RED);
        this.game.shapeRenderer.end();
        this.game.batch.begin();
        this.game.font33Red.draw((Batch)this.game.batch, "X", this.screenWidth / 1.074f, this.screenHeight / 1.09f);
        this.game.batch.end();
    }

    public Rectangle getExitButton() {
        return this.exitButton;
    }
}

