/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.mozarellabytes.kroy.Kroy;
import com.mozarellabytes.kroy.Utilities.GameOverInputHandler;

public class GameOverScreen
implements Screen {
    private final Kroy game;
    private final Texture backgroundLogo;
    private final OrthographicCamera camera;
    private final GlyphLayout layout;
    private String text;

    public GameOverScreen(Kroy game, boolean won) {
        this.game = game;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height);
        this.backgroundLogo = new Texture(Gdx.files.internal("images/backgroundLogo.png"), true);
        this.backgroundLogo.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        Gdx.input.setInputProcessor(new GameOverInputHandler(game));
        this.layout = new GlyphLayout();
        this.text = won ? "We did it! Good job little guy." : "Mission Failed. We'll get 'em next time.";
        this.text = this.text + "\n   Click to return to the main menu...";
        this.layout.setText(game.font26, this.text);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.2f, 0.13333334f, 0.3882353f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.game.batch.begin();
        this.game.font26.draw((Batch)this.game.batch, this.text, this.camera.viewportWidth / 2.0f - this.layout.width / 2.0f, this.camera.viewportHeight / 2.0f - this.layout.height / 2.0f);
        this.game.batch.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.backgroundLogo.dispose();
    }
}

