/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Vector2;
import com.mozarellabytes.kroy.Entities.Bomb;
import com.mozarellabytes.kroy.Entities.FireStation;
import com.mozarellabytes.kroy.Entities.FireTruck;
import com.mozarellabytes.kroy.Entities.FireTruckType;
import com.mozarellabytes.kroy.Entities.Fortress;
import com.mozarellabytes.kroy.Entities.FortressType;
import com.mozarellabytes.kroy.GameState;
import com.mozarellabytes.kroy.Kroy;
import com.mozarellabytes.kroy.Screens.ControlsScreen;
import com.mozarellabytes.kroy.Screens.MenuScreen;
import com.mozarellabytes.kroy.Utilities.CameraShake;
import com.mozarellabytes.kroy.Utilities.GUI;
import com.mozarellabytes.kroy.Utilities.GameInputHandler;
import com.mozarellabytes.kroy.Utilities.SoundFX;
import java.util.ArrayList;

public class GameScreen
implements Screen {
    private final Kroy game;
    private final OrthogonalTiledMapRenderer mapRenderer;
    private final OrthographicCamera camera;
    private final ShapeRenderer shapeMapRenderer;
    private final MapLayers mapLayers;
    private final int[] structureLayersIndices;
    private final int[] backgroundLayerIndex;
    private final Batch mapBatch;
    private final CameraShake camShake;
    private PlayState state;
    private final GUI gui;
    public final GameState gameState;
    private final ArrayList<Fortress> fortresses;
    private final FireStation station;
    public FireTruck selectedTruck;
    public Object selectedEntity;

    public GameScreen(Kroy game) {
        this.game = game;
        this.state = PlayState.PLAY;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 40.0f, 24.0f);
        TiledMap map = new TmxMapLoader().load("maps/YorkMap.tmx");
        this.mapRenderer = new OrthogonalTiledMapRenderer(map, 0.020833334f);
        this.mapRenderer.setView(this.camera);
        this.shapeMapRenderer = new ShapeRenderer();
        this.shapeMapRenderer.setProjectionMatrix(this.camera.combined);
        this.gui = new GUI(game, this);
        Gdx.input.setInputProcessor(new GameInputHandler(this, this.gui));
        this.gameState = new GameState();
        this.camShake = new CameraShake();
        this.mapLayers = map.getLayers();
        this.backgroundLayerIndex = new int[]{this.mapLayers.getIndex("background")};
        this.structureLayersIndices = new int[]{this.mapLayers.getIndex("structures"), this.mapLayers.getIndex("structures2"), this.mapLayers.getIndex("transparentStructures")};
        this.station = new FireStation(3, 2);
        this.spawn(FireTruckType.Ocean);
        this.spawn(FireTruckType.Speed);
        this.fortresses = new ArrayList();
        this.fortresses.add(new Fortress(12.0f, 18.5f, FortressType.Revs));
        this.fortresses.add(new Fortress(30.5f, 17.5f, FortressType.Walmgate));
        this.fortresses.add(new Fortress(16.0f, 3.5f, FortressType.Clifford));
        for (FireTruck truck : this.station.getTrucks()) {
            truck.setOrigin(24.0f, 24.0f);
        }
        this.mapBatch = this.mapRenderer.getBatch();
        if (SoundFX.music_enabled) {
            SoundFX.sfx_soundtrack.setVolume(0.5f);
            SoundFX.sfx_soundtrack.play();
        }
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        this.camera.update();
        this.mapRenderer.setView(this.camera);
        this.mapRenderer.render(this.backgroundLayerIndex);
        this.mapBatch.begin();
        for (FireTruck truck : this.station.getTrucks()) {
            truck.drawPath(this.mapBatch);
            truck.drawSprite(this.mapBatch);
        }
        this.station.draw(this.mapBatch);
        for (Fortress fortress : this.fortresses) {
            fortress.draw(this.mapBatch);
        }
        this.mapBatch.end();
        this.mapRenderer.render(this.structureLayersIndices);
        this.shapeMapRenderer.begin(ShapeRenderer.ShapeType.Filled);
        for (FireTruck truck : this.station.getTrucks()) {
            truck.drawStats(this.shapeMapRenderer);
        }
        for (Fortress fortress : this.fortresses) {
            fortress.drawStats(this.shapeMapRenderer);
            for (Bomb bomb : fortress.getBombs()) {
                bomb.drawBomb(this.shapeMapRenderer);
            }
        }
        this.shapeMapRenderer.end();
        this.gui.renderSelectedEntity(this.selectedEntity);
        switch (this.state) {
            case PLAY: {
                this.update(delta);
                break;
            }
            case PAUSE: {
                Gdx.graphics.getGL20().glEnable(3042);
                this.shapeMapRenderer.begin(ShapeRenderer.ShapeType.Filled);
                this.shapeMapRenderer.setColor(0.0f, 0.0f, 0.0f, 0.5f);
                this.shapeMapRenderer.rect(0.0f, 0.0f, this.camera.viewportWidth, this.camera.viewportHeight);
                this.shapeMapRenderer.end();
                this.gui.renderPauseScreenText();
            }
        }
        this.gui.renderButtons();
    }

    private void update(float delta) {
        int i;
        this.gameState.hasGameEnded(this.game);
        CameraShake.update(delta, this.camera, new Vector2(this.camera.viewportWidth / 2.0f, this.camera.viewportHeight / 2.0f));
        this.station.restoreTrucks();
        this.station.checkForCollisions();
        this.gameState.setTrucksInAttackRange(0);
        for (i = 0; i < this.station.getTrucks().size(); ++i) {
            FireTruck truck = this.station.getTruck(i);
            truck.move();
            truck.updateSpray();
            for (Fortress fortress : this.fortresses) {
                if (fortress.withinRange(truck.getVisualPosition())) {
                    fortress.attack(truck, true);
                }
                if (!truck.fortressInRange(fortress.getPosition())) continue;
                this.gameState.incrementTrucksInAttackRange();
                truck.attack(fortress);
                break;
            }
            if (!(truck.getHP() <= 0.0f)) continue;
            this.gameState.removeFireTruck();
            this.station.destroyTruck(truck);
            if (!truck.equals(this.selectedTruck)) continue;
            this.selectedTruck = null;
        }
        for (i = 0; i < this.fortresses.size(); ++i) {
            Fortress fortress = this.fortresses.get(i);
            boolean hitTruck = fortress.updateBombs();
            if (hitTruck) {
                this.camShake.shakeIt(0.2f);
            }
            if (!(fortress.getHP() <= 0.0f)) continue;
            this.gameState.addFortress();
            this.fortresses.remove(fortress);
            if (!SoundFX.music_enabled) continue;
            SoundFX.sfx_fortress_destroyed.play();
        }
        if (Gdx.input.isKeyPressed(29)) {
            if (this.gameState.getTrucksInAttackRange() > 0) {
                SoundFX.playTruckAttack();
            } else {
                SoundFX.stopTruckAttack();
            }
        }
        System.out.println(SoundFX.isPlaying);
        this.shapeMapRenderer.end();
        this.shapeMapRenderer.setColor(Color.WHITE);
        this.gui.renderSelectedEntity(this.selectedEntity);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.mapRenderer.dispose();
        this.shapeMapRenderer.dispose();
        this.mapBatch.dispose();
        SoundFX.sfx_soundtrack.stop();
    }

    public boolean checkClick(Vector2 position) {
        for (int i = this.station.getTrucks().size() - 1; i >= 0; --i) {
            FireTruck selectedTruck = this.station.getTruck(i);
            Vector2 truckTile = this.getTile(selectedTruck.getPosition());
            if (!position.equals(truckTile) || selectedTruck.getMoving()) continue;
            this.selectedTruck = this.station.getTruck(i);
            this.selectedEntity = this.station.getTruck(i);
            return true;
        }
        return false;
    }

    private Vector2 getTile(Vector2 position) {
        return new Vector2(Math.round(position.x), Math.round(position.y));
    }

    public boolean checkTrailClick(Vector2 position) {
        for (int i = this.station.getTrucks().size() - 1; i >= 0; --i) {
            if (this.station.getTruck((int)i).path.isEmpty() || !position.equals(this.station.getTruck((int)i).path.last())) continue;
            this.selectedTruck = this.station.getTruck(i);
            this.selectedEntity = this.station.getTruck(i);
            return true;
        }
        return false;
    }

    public boolean isRoad(int x, int y) {
        return ((TiledMapTileLayer)this.mapLayers.get("collisions")).getCell(x, y).getTile().getProperties().get("road").equals(true);
    }

    public void toControlScreen() {
        this.game.setScreen(new ControlsScreen(this.game, this, "game"));
    }

    public void toHomeScreen() {
        this.game.setScreen(new MenuScreen(this.game));
        SoundFX.sfx_soundtrack.dispose();
    }

    private void spawn(FireTruckType type) {
        SoundFX.sfx_truck_spawn.play();
        this.station.spawn(new FireTruck(this, new Vector2(6.0f, 2.0f), type));
        this.gameState.addFireTruck();
    }

    public void changeState() {
        this.state = this.state.equals((Object)PlayState.PLAY) ? PlayState.PAUSE : PlayState.PLAY;
    }

    public FireStation getStation() {
        return this.station;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public ArrayList<Fortress> getFortresses() {
        return this.fortresses;
    }

    public PlayState getState() {
        return this.state;
    }

    public static enum PlayState {
        PLAY,
        PAUSE;

    }
}

