/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Rectangle;
import com.mozarellabytes.kroy.Kroy;
import com.mozarellabytes.kroy.Screens.ControlsScreen;
import com.mozarellabytes.kroy.Screens.GameScreen;
import com.mozarellabytes.kroy.Utilities.MenuInputHandler;
import com.mozarellabytes.kroy.Utilities.SoundFX;

public class MenuScreen
implements Screen {
    private final Kroy game;
    public final OrthographicCamera camera;
    private final Texture backgroundImage;
    private final Rectangle startButton;
    private final Texture startIdleTexture;
    private final Texture startClickedTexture;
    private Texture currentStartTexture;
    private final Rectangle controlsButton;
    private final Texture controlsIdleTexture;
    private final Texture controlsClickedTexture;
    private Texture currentControlsTexture;
    private final Rectangle soundButton;
    private final Texture soundOnIdleTexture;
    private final Texture soundOffIdleTexture;
    private final Texture soundOnClickedTexture;
    private final Texture soundOffClickedTexture;
    private Texture currentSoundTexture;

    public MenuScreen(Kroy game) {
        this.game = game;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height);
        this.backgroundImage = new Texture(Gdx.files.internal("menuscreen_blank_2.png"), true);
        this.backgroundImage.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.startIdleTexture = new Texture(Gdx.files.internal("ui/start_idle.png"), true);
        this.startIdleTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.startClickedTexture = new Texture(Gdx.files.internal("ui/start_clicked.png"), true);
        this.startClickedTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.controlsIdleTexture = new Texture(Gdx.files.internal("ui/controls_idle.png"), true);
        this.controlsIdleTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.controlsClickedTexture = new Texture(Gdx.files.internal("ui/controls_clicked.png"), true);
        this.controlsClickedTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOnIdleTexture = new Texture(Gdx.files.internal("ui/sound_on_idle.png"), true);
        this.soundOnIdleTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOffIdleTexture = new Texture(Gdx.files.internal("ui/sound_off_idle.png"), true);
        this.soundOffIdleTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOnClickedTexture = new Texture(Gdx.files.internal("ui/sound_on_clicked.png"), true);
        this.soundOnClickedTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOffClickedTexture = new Texture(Gdx.files.internal("ui/sound_off_clicked.png"), true);
        this.soundOffClickedTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        MenuInputHandler ih = new MenuInputHandler(this);
        if (SoundFX.music_enabled) {
            SoundFX.sfx_menu.setLooping(true);
            SoundFX.sfx_menu.play();
            this.currentSoundTexture = this.soundOffIdleTexture;
        } else {
            this.currentSoundTexture = this.soundOnIdleTexture;
        }
        this.currentStartTexture = this.startIdleTexture;
        this.currentControlsTexture = this.controlsIdleTexture;
        this.startButton = new Rectangle();
        this.startButton.width = (float)((double)this.currentStartTexture.getWidth() * 0.75);
        this.startButton.height = (float)((double)this.currentStartTexture.getHeight() * 0.75);
        this.startButton.x = (int)(this.camera.viewportWidth / 2.0f - this.startButton.width / 2.0f);
        this.startButton.y = (int)((double)(this.camera.viewportHeight / 2.0f - this.startButton.height / 2.0f) * 0.8);
        this.controlsButton = new Rectangle();
        this.controlsButton.width = (float)((double)this.currentControlsTexture.getWidth() * 0.75);
        this.controlsButton.height = (float)((double)this.currentControlsTexture.getHeight() * 0.75);
        this.controlsButton.x = (int)(this.camera.viewportWidth / 2.0f - this.controlsButton.width / 2.0f);
        this.controlsButton.y = (int)((double)(this.camera.viewportHeight / 2.0f - this.controlsButton.height / 2.0f) * 0.4);
        this.soundButton = new Rectangle();
        this.soundButton.width = 50.0f;
        this.soundButton.height = 50.0f;
        this.soundButton.x = this.camera.viewportWidth - this.soundButton.getWidth() - 5.0f;
        this.soundButton.y = this.camera.viewportHeight - this.soundButton.getHeight() - 5.0f;
        Gdx.input.setInputProcessor(ih);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.2f, 0.13333334f, 0.3882353f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.game.batch.begin();
        this.game.batch.draw(this.backgroundImage, 0.0f, 0.0f, this.camera.viewportWidth, this.camera.viewportHeight);
        this.game.batch.draw(this.currentStartTexture, this.startButton.x, this.startButton.y, this.startButton.width, this.startButton.height);
        this.game.batch.draw(this.currentControlsTexture, this.controlsButton.x, this.controlsButton.y, this.controlsButton.width, this.controlsButton.height);
        this.game.batch.draw(this.currentSoundTexture, this.soundButton.x, this.soundButton.y, this.soundButton.width, this.soundButton.height);
        this.game.batch.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.backgroundImage.dispose();
        this.currentStartTexture.dispose();
        this.startClickedTexture.dispose();
        this.startIdleTexture.dispose();
        this.currentControlsTexture.dispose();
        this.controlsClickedTexture.dispose();
        this.controlsIdleTexture.dispose();
        this.currentSoundTexture.dispose();
        this.soundOnIdleTexture.dispose();
        this.soundOnClickedTexture.dispose();
        this.soundOffIdleTexture.dispose();
        this.soundOffClickedTexture.dispose();
        SoundFX.sfx_menu.stop();
    }

    public void toGameScreen() {
        this.game.setScreen(new GameScreen(this.game));
        this.dispose();
    }

    public void clickedStartButton() {
        if (SoundFX.music_enabled) {
            SoundFX.sfx_button_clicked.play();
        }
        this.currentStartTexture = this.startClickedTexture;
    }

    public void clickedControlsButton() {
        if (SoundFX.music_enabled) {
            SoundFX.sfx_button_clicked.play();
        }
        this.currentControlsTexture = this.controlsClickedTexture;
    }

    public void clickedSoundButton() {
        this.currentSoundTexture = SoundFX.music_enabled ? this.soundOffClickedTexture : this.soundOnClickedTexture;
    }

    public void changeSound() {
        if (SoundFX.music_enabled) {
            this.currentSoundTexture = this.soundOnIdleTexture;
            SoundFX.stopMusic();
        } else {
            this.currentSoundTexture = this.soundOffIdleTexture;
            SoundFX.playMenuMusic();
        }
    }

    public void idleStartButton() {
        this.currentStartTexture = this.startIdleTexture;
    }

    public void idleControlsButton() {
        this.currentControlsTexture = this.controlsIdleTexture;
    }

    public void idleSoundButton() {
        this.currentSoundTexture = SoundFX.music_enabled ? this.soundOffIdleTexture : this.soundOnIdleTexture;
    }

    public void toControlScreen() {
        this.game.setScreen(new ControlsScreen(this.game, this, "menu"));
    }

    public Rectangle getStartButton() {
        return this.startButton;
    }

    public Rectangle getControlsButton() {
        return this.controlsButton;
    }

    public Rectangle getSoundButton() {
        return this.soundButton;
    }
}

