/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.TimeUtils;
import com.mozarellabytes.kroy.Kroy;
import com.mozarellabytes.kroy.Screens.ControlsScreen;
import com.mozarellabytes.kroy.Screens.MenuScreen;

public class SplashScreen
implements Screen {
    private final Kroy game;
    private final Texture backgroundLogo;
    private long startTime;

    public SplashScreen(Kroy game) {
        this.game = game;
        this.backgroundLogo = new Texture(Gdx.files.internal("images/backgroundLogo.png"), true);
        this.backgroundLogo.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
    }

    @Override
    public void show() {
        this.startTime = TimeUtils.millis();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.game.batch.begin();
        this.game.batch.draw(this.backgroundLogo, 0.0f, 0.0f, (float)Gdx.app.getGraphics().getWidth(), (float)Gdx.app.getGraphics().getHeight());
        this.game.batch.end();
        if (TimeUtils.timeSinceMillis(this.startTime) > 3000L) {
            this.game.setScreen(new ControlsScreen(this.game, new MenuScreen(this.game), "menu"));
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.backgroundLogo.dispose();
    }
}

