/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Utilities;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import java.util.Random;

public class CameraShake {
    private static float[] samples;
    private static float internalTimer;
    private static float shakeDuration;
    private static final int amount = 5;
    private static final int frequency = 35;
    private static int sampleCount;

    public CameraShake() {
        sampleCount = 175;
        samples = new float[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            Random rand = new Random();
            CameraShake.samples[i] = rand.nextFloat() * 2.0f - 1.0f;
        }
    }

    public static void update(float delta, Camera camera, Vector2 center) {
        if ((internalTimer += delta) > 5.0f) {
            internalTimer -= 5.0f;
        }
        if (shakeDuration > 0.0f) {
            shakeDuration -= delta;
            float shakeTime = internalTimer * 35.0f;
            int first = (int)shakeTime;
            int second = (first + 1) % sampleCount;
            int third = (first + 2) % sampleCount;
            float deltaT = shakeTime - (float)((int)shakeTime);
            float deltaX = samples[first] * deltaT + samples[second] * (1.0f - deltaT);
            float deltaY = samples[second] * deltaT + samples[third] * (1.0f - deltaT);
            boolean falloff = true;
            float amplitude = 2.0f;
            camera.position.x = center.x + deltaX * amplitude * (falloff ? Math.min(shakeDuration, 1.0f) : 1.0f);
            camera.position.y = center.y + deltaY * amplitude * (falloff ? Math.min(shakeDuration, 1.0f) : 1.0f);
            camera.update();
        }
    }

    public void shakeIt(float seconds) {
        shakeDuration = seconds;
    }

    static {
        internalTimer = 0.0f;
        shakeDuration = 0.0f;
    }
}

