/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Utilities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.mozarellabytes.kroy.Entities.FireTruck;
import com.mozarellabytes.kroy.Entities.Fortress;
import com.mozarellabytes.kroy.Kroy;
import com.mozarellabytes.kroy.Screens.GameScreen;
import com.mozarellabytes.kroy.Utilities.SoundFX;

public class GUI {
    private final Kroy game;
    private final int selectedX;
    private final int selectedY;
    private final int selectedH;
    private final int selectedW;
    private final GameScreen gameScreen;
    private final Rectangle homeButton;
    private final Texture homeButtonIdle;
    private final Texture homeButtonClicked;
    private Texture currentHomeTexture;
    private final Rectangle pauseButton;
    private final Texture pauseButtonIdle;
    private final Texture pauseButtonClicked;
    private Texture currentPauseTexture;
    private final Rectangle infoButton;
    private final Texture infoButtonIdle;
    private final Texture infoButtonClicked;
    private Texture currentInfoTexture;
    private final Rectangle soundButton;
    private final Texture soundOnIdleTexture;
    private final Texture soundOffIdleTexture;
    private final Texture soundOnClickedTexture;
    private final Texture soundOffClickedTexture;
    private Texture currentSoundTexture;
    private final OrthographicCamera pauseCamera;

    public GUI(Kroy game, GameScreen gameScreen) {
        this.game = game;
        this.gameScreen = gameScreen;
        this.selectedH = 275;
        this.selectedW = 275;
        this.selectedX = 10;
        this.selectedY = Gdx.graphics.getHeight() - 10 - this.selectedH;
        this.homeButtonIdle = new Texture(Gdx.files.internal("ui/home_idle.png"), true);
        this.homeButtonIdle.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.homeButtonClicked = new Texture(Gdx.files.internal("ui/home_clicked.png"), true);
        this.homeButtonClicked.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.pauseButtonIdle = new Texture(Gdx.files.internal("ui/pause_idle.png"), true);
        this.pauseButtonIdle.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.pauseButtonClicked = new Texture(Gdx.files.internal("ui/pause_clicked.png"), true);
        this.pauseButtonClicked.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.infoButtonIdle = new Texture(Gdx.files.internal("ui/info_idle.png"), true);
        this.infoButtonIdle.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.infoButtonClicked = new Texture(Gdx.files.internal("ui/info_clicked.png"), true);
        this.infoButtonClicked.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOnIdleTexture = new Texture(Gdx.files.internal("ui/sound_on_idle.png"), true);
        this.soundOnIdleTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOffIdleTexture = new Texture(Gdx.files.internal("ui/sound_off_idle.png"), true);
        this.soundOffIdleTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOnClickedTexture = new Texture(Gdx.files.internal("ui/sound_on_clicked.png"), true);
        this.soundOnClickedTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.soundOffClickedTexture = new Texture(Gdx.files.internal("ui/sound_off_clicked.png"), true);
        this.soundOffClickedTexture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.MipMapLinearNearest);
        this.currentHomeTexture = this.homeButtonIdle;
        this.currentPauseTexture = this.pauseButtonIdle;
        this.currentInfoTexture = this.infoButtonIdle;
        this.currentSoundTexture = SoundFX.music_enabled ? this.soundOffIdleTexture : this.soundOnIdleTexture;
        this.homeButton = new Rectangle(Gdx.graphics.getWidth() - 33, Gdx.graphics.getHeight() - 33, 30.0f, 30.0f);
        this.soundButton = new Rectangle(Gdx.graphics.getWidth() - 70, Gdx.graphics.getHeight() - 33, 30.0f, 30.0f);
        this.pauseButton = new Rectangle(Gdx.graphics.getWidth() - 107, Gdx.graphics.getHeight() - 33, 30.0f, 30.0f);
        this.infoButton = new Rectangle(Gdx.graphics.getWidth() - 144, Gdx.graphics.getHeight() - 33, 30.0f, 30.0f);
        this.pauseCamera = new OrthographicCamera();
        this.pauseCamera.setToOrtho(false, Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height);
    }

    public void renderSelectedEntity(Object entity) {
        if (entity != null) {
            Gdx.graphics.getGL20().glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
            this.game.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            this.renderSelectedEntityBackground();
            this.game.shapeRenderer.end();
            this.game.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            if (entity instanceof FireTruck) {
                FireTruck truck = (FireTruck)entity;
                this.renderSelectedTruck(truck);
            } else if (entity instanceof Fortress) {
                Fortress fortress = (Fortress)entity;
                this.renderSelectedFortress(fortress);
            }
            this.game.shapeRenderer.end();
        }
    }

    private void renderSelectedEntityBackground() {
        this.game.shapeRenderer.setColor(0.0f, 0.0f, 0.0f, 0.5f);
        this.game.shapeRenderer.rect(this.selectedX, this.selectedY, this.selectedW, this.selectedH);
    }

    private void renderSelectedTruck(FireTruck truck) {
        this.renderSelectedEntityBar(truck.getHP(), truck.getType().getMaxHP(), Color.RED, Color.FIREBRICK, 1);
        this.renderSelectedEntityBar(truck.getReserve(), truck.getType().getMaxReserve(), Color.CYAN, Color.BLUE, 2);
        this.renderSelectedEntityText(truck);
    }

    private void renderSelectedFortress(Fortress fortress) {
        this.renderSelectedEntityBar(fortress.getHP(), fortress.getFortressType().getMaxHP(), Color.RED, Color.FIREBRICK, 1);
        this.renderSelectedEntityText(fortress);
    }

    private void renderSelectedEntityText(FireTruck truck) {
        int newLine = 20;
        this.game.batch.begin();
        this.game.font26.draw((Batch)this.game.batch, truck.getType().getName(), (float)(this.selectedX + 10), (float)(this.selectedY + this.selectedH - 10));
        this.game.font19.draw((Batch)this.game.batch, "HP: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.1f", Float.valueOf(truck.getHP())) + " / " + String.format("%.1f", Float.valueOf(truck.getType().getMaxHP())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine));
        this.game.font19.draw((Batch)this.game.batch, "Reserve: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50 - newLine * 2));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.1f", Float.valueOf(truck.getReserve())) + " / " + String.format("%.1f", Float.valueOf(truck.getType().getMaxReserve())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine * 3));
        this.game.font19.draw((Batch)this.game.batch, "Speed: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50 - newLine * 4));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.1f", Float.valueOf(truck.getType().getSpeed())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine * 5));
        this.game.font19.draw((Batch)this.game.batch, "Range: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50 - newLine * 6));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.1f", Float.valueOf(truck.getType().getRange())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine * 7));
        this.game.font19.draw((Batch)this.game.batch, "AP: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50 - newLine * 8));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.2f", Float.valueOf(truck.getType().getAP())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine * 9));
        this.game.batch.end();
    }

    private void renderSelectedEntityText(Fortress fortress) {
        int newLine = 20;
        this.game.batch.begin();
        this.game.font26.draw((Batch)this.game.batch, fortress.getFortressType().getName(), (float)(this.selectedX + 10), (float)(this.selectedY + this.selectedH - 10));
        this.game.font19.draw((Batch)this.game.batch, "HP: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.1f", Float.valueOf(fortress.getHP())) + " / " + String.format("%.1f", Float.valueOf(fortress.getFortressType().getMaxHP())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine));
        this.game.font19.draw((Batch)this.game.batch, "Range: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50 - newLine * 2));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.1f", Float.valueOf(fortress.getFortressType().getRange())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine * 3));
        this.game.font19.draw((Batch)this.game.batch, "AP: ", (float)(this.selectedX + 15), (float)(this.selectedY + this.selectedH - 50 - newLine * 4));
        this.game.font19.draw((Batch)this.game.batch, String.format("%.2f", Float.valueOf(fortress.getFortressType().getAP())), (float)(this.selectedX + 20), (float)(this.selectedY + this.selectedH - 50 - newLine * 5));
        this.game.batch.end();
    }

    private void renderSelectedEntityBar(float value, float maxValue, Color progressColour, Color backgroundColour, int position) {
        int whiteW = 50;
        int outerSpacing = 10;
        int innerSpacing = 5;
        int spaceForText = 35;
        int barHeight = this.selectedH - outerSpacing * 2 - innerSpacing * 2 - spaceForText;
        int positionSpacer = position * whiteW;
        int barSpacer = 0;
        if (position > 1) {
            barSpacer = 5;
        }
        this.game.shapeRenderer.rect(this.selectedX + this.selectedW - positionSpacer - outerSpacing - barSpacer, this.selectedY + outerSpacing, whiteW, this.selectedH - outerSpacing * 2 - spaceForText, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE);
        this.game.shapeRenderer.rect(this.selectedX + this.selectedW - positionSpacer - outerSpacing + innerSpacing - barSpacer, this.selectedY + outerSpacing + innerSpacing, whiteW - innerSpacing * 2, barHeight, backgroundColour, backgroundColour, backgroundColour, backgroundColour);
        this.game.shapeRenderer.rect(this.selectedX + this.selectedW - positionSpacer - outerSpacing + innerSpacing - barSpacer, this.selectedY + outerSpacing + innerSpacing, whiteW - innerSpacing * 2, value / maxValue * (float)barHeight, progressColour, progressColour, progressColour, progressColour);
    }

    public void renderButtons() {
        this.game.batch.begin();
        this.game.batch.draw(this.currentSoundTexture, this.soundButton.x, this.soundButton.y, this.soundButton.width, this.soundButton.height);
        this.game.batch.draw(this.currentHomeTexture, this.homeButton.x, this.homeButton.y, this.homeButton.width, this.homeButton.height);
        this.game.batch.draw(this.currentPauseTexture, this.pauseButton.x, this.pauseButton.y, this.pauseButton.width, this.pauseButton.height);
        this.game.batch.draw(this.currentInfoTexture, this.infoButton.x, this.infoButton.y, this.infoButton.width, this.infoButton.height);
        this.game.batch.end();
    }

    public void clickedHomeButton() {
        if (SoundFX.music_enabled) {
            SoundFX.sfx_button_clicked.play();
        }
        this.currentHomeTexture = this.homeButtonClicked;
    }

    public void clickedInfoButton() {
        this.currentInfoTexture = this.currentInfoTexture == this.infoButtonIdle ? this.infoButtonClicked : this.infoButtonIdle;
    }

    public void clickedSoundButton() {
        this.currentSoundTexture = SoundFX.music_enabled ? this.soundOffClickedTexture : this.soundOnClickedTexture;
    }

    public void clickedPauseButton() {
        if (this.gameScreen.getState().equals((Object)GameScreen.PlayState.PLAY)) {
            this.currentPauseTexture = this.pauseButtonClicked;
            if (SoundFX.music_enabled) {
                SoundFX.sfx_pause.play();
            }
        } else {
            this.currentPauseTexture = this.pauseButtonIdle;
            if (SoundFX.music_enabled) {
                SoundFX.sfx_unpause.play();
            }
        }
    }

    public void idleHomeButton() {
        this.currentHomeTexture = this.homeButtonIdle;
    }

    public void idlePauseButton() {
        this.currentPauseTexture = this.pauseButtonIdle;
    }

    public void idleInfoButton() {
        this.currentInfoTexture = this.infoButtonIdle;
    }

    public void idleSoundButton() {
        this.currentSoundTexture = SoundFX.music_enabled ? this.soundOffIdleTexture : this.soundOnIdleTexture;
    }

    public void changeSound() {
        if (SoundFX.music_enabled) {
            this.currentSoundTexture = this.soundOnIdleTexture;
            SoundFX.stopMusic();
        } else {
            this.currentSoundTexture = this.soundOffIdleTexture;
            SoundFX.playGameMusic();
        }
    }

    public void renderPauseScreenText() {
        GlyphLayout layout = new GlyphLayout();
        String pauseText1 = "Game paused \n";
        String pauseText2 = "Press 'P' or the Pause button \n To return to game";
        layout.setText(this.game.font26, pauseText1);
        layout.setText(this.game.font26, pauseText2);
        this.game.batch.setProjectionMatrix(this.pauseCamera.combined);
        this.game.batch.begin();
        this.game.font50.draw((Batch)this.game.batch, pauseText1, this.pauseCamera.viewportWidth / 2.0f - layout.width / 2.7f, this.pauseCamera.viewportHeight / 1.8f - layout.height / 2.0f);
        this.game.font26.draw((Batch)this.game.batch, pauseText2, this.pauseCamera.viewportWidth / 2.0f - layout.width / 2.0f, this.pauseCamera.viewportHeight / 2.3f - layout.height / 2.0f);
        this.game.batch.end();
    }

    public Rectangle getHomeButton() {
        return this.homeButton;
    }

    public Rectangle getSoundButton() {
        return this.soundButton;
    }

    public Rectangle getPauseButton() {
        return this.pauseButton;
    }

    public Rectangle getInfoButton() {
        return this.infoButton;
    }
}

