/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Utilities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.mozarellabytes.kroy.Entities.FireTruck;
import com.mozarellabytes.kroy.Entities.Fortress;
import com.mozarellabytes.kroy.Screens.GameScreen;
import com.mozarellabytes.kroy.Utilities.GUI;
import com.mozarellabytes.kroy.Utilities.SoundFX;

public class GameInputHandler
implements InputProcessor {
    private final GameScreen gameScreen;
    private final GUI gui;

    public GameInputHandler(GameScreen gameScreen, GUI gui) {
        this.gameScreen = gameScreen;
        this.gui = gui;
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 131: {
                Gdx.app.exit();
                System.exit(1);
                break;
            }
            case 29: {
                System.out.println(this.gameScreen.gameState.getTrucksInAttackRange());
                if (SoundFX.music_enabled && this.gameScreen.gameState.getTrucksInAttackRange() > 0) {
                    SoundFX.playTruckAttack();
                }
                for (FireTruck truck : this.gameScreen.getStation().getTrucks()) {
                    truck.setAttacking(true);
                }
                break;
            }
            case 31: {
                this.gameScreen.toControlScreen();
                break;
            }
            case 47: {
                this.gui.clickedSoundButton();
                this.gui.changeSound();
                this.gui.idleSoundButton();
                break;
            }
            case 44: {
                this.gui.clickedPauseButton();
                this.gameScreen.changeState();
            }
        }
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (this.gameScreen.getState().equals((Object)GameScreen.PlayState.PLAY) && keycode == 29) {
            SoundFX.stopTruckAttack();
            for (FireTruck truck : this.gameScreen.getStation().getTrucks()) {
                truck.setAttacking(false);
            }
        }
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 clickCoordinates = this.generateClickCoordinates(screenX, screenY);
        if (this.gameScreen.getState().equals((Object)GameScreen.PlayState.PLAY)) {
            if (this.gameScreen.isRoad((int)clickCoordinates.x, (int)clickCoordinates.y)) {
                if (this.gameScreen.checkClick(clickCoordinates)) {
                    this.gameScreen.selectedTruck.resetPath();
                    this.gameScreen.selectedTruck.addTileToPath(clickCoordinates);
                } else if (!this.gameScreen.checkTrailClick(clickCoordinates) && !this.checkFortressClick(clickCoordinates)) {
                    this.gameScreen.selectedTruck = null;
                    this.gameScreen.selectedEntity = null;
                }
            } else {
                this.checkFortressClick(clickCoordinates);
            }
        }
        this.checkButtonClick(new Vector2(screenX, Gdx.graphics.getHeight() - screenY));
        return true;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.gameScreen.getState().equals((Object)GameScreen.PlayState.PLAY) && this.gameScreen.selectedTruck != null) {
            Vector2 clickCoordinates = this.generateClickCoordinates(screenX, screenY);
            this.gameScreen.selectedTruck.addTileToPath(clickCoordinates);
        }
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.gameScreen.getState().equals((Object)GameScreen.PlayState.PLAY) && this.gameScreen.selectedTruck != null) {
            if (!this.gameScreen.selectedTruck.trailPath.isEmpty() && this.doTrucksHaveSameLastTile()) {
                this.giveTrucksDifferentLastTiles(this.gameScreen.selectedTruck);
            }
            this.gameScreen.selectedTruck.setMoving(true);
        }
        this.checkButtonUnclick(screenX, screenY);
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    private boolean doTrucksHaveSameLastTile() {
        for (FireTruck truck : this.gameScreen.getStation().getTrucks()) {
            if (truck.equals(this.gameScreen.selectedTruck) || !(!truck.getPath().isEmpty() && !truck.getTrailPath().isEmpty() ? truck.trailPath.last().equals(this.gameScreen.selectedTruck.trailPath.last()) : truck.getPosition().equals(this.gameScreen.selectedTruck.trailPath.last()))) continue;
            return true;
        }
        return false;
    }

    private void giveTrucksDifferentLastTiles(FireTruck selectedTruck) {
        selectedTruck.trailPath.removeLast();
        while (!selectedTruck.trailPath.isEmpty() && !selectedTruck.trailPath.last().equals(selectedTruck.path.last())) {
            selectedTruck.path.removeLast();
        }
    }

    private Vector2 generateClickCoordinates(int screenX, int screenY) {
        Vector2 clickCoordinates = new Vector2(screenX, screenY);
        Vector3 position = this.gameScreen.getCamera().unproject(new Vector3(clickCoordinates.x, clickCoordinates.y, 0.0f));
        return new Vector2((int)position.x, (int)position.y);
    }

    private void checkButtonClick(Vector2 position2d) {
        if (this.gui.getHomeButton().contains(position2d)) {
            this.gui.clickedHomeButton();
        } else if (this.gui.getPauseButton().contains(position2d)) {
            this.gui.clickedPauseButton();
        } else if (this.gui.getSoundButton().contains(position2d)) {
            this.gui.clickedSoundButton();
        } else if (this.gui.getInfoButton().contains(position2d)) {
            this.gui.clickedInfoButton();
        }
    }

    private boolean checkFortressClick(Vector2 position2d) {
        for (Fortress fortress : this.gameScreen.getFortresses()) {
            if (!fortress.getArea().contains(position2d)) continue;
            this.gameScreen.selectedEntity = fortress;
            return true;
        }
        this.gameScreen.selectedTruck = null;
        this.gameScreen.selectedEntity = null;
        return false;
    }

    private void checkButtonUnclick(int screenX, int screenY) {
        Vector2 screenCoords = new Vector2(screenX, Gdx.graphics.getHeight() - screenY);
        if (this.gui.getHomeButton().contains(screenCoords)) {
            this.gameScreen.toHomeScreen();
        } else {
            this.gui.idleHomeButton();
        }
        if (this.gui.getSoundButton().contains(screenCoords)) {
            this.gui.changeSound();
        } else {
            this.gui.idleSoundButton();
        }
        if (this.gui.getPauseButton().contains(screenCoords)) {
            this.gameScreen.changeState();
        } else {
            this.gui.idlePauseButton();
        }
        if (this.gui.getInfoButton().contains(screenCoords)) {
            this.gameScreen.toControlScreen();
        }
    }
}

