/*
 * Decompiled with CFR 0.152.
 */
package com.mozarellabytes.kroy.Utilities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.mozarellabytes.kroy.Screens.MenuScreen;
import com.mozarellabytes.kroy.Utilities.SoundFX;

public class MenuInputHandler
implements InputProcessor {
    private final MenuScreen menu;

    public MenuInputHandler(MenuScreen menu) {
        this.menu = menu;
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 131: {
                Gdx.app.exit();
                System.exit(1);
                break;
            }
            case 31: {
                this.menu.clickedControlsButton();
                this.menu.toControlScreen();
                break;
            }
            case 47: {
                this.menu.clickedSoundButton();
                this.menu.changeSound();
            }
        }
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 29) {
            SoundFX.sfx_truck_attack.stop();
        }
        return true;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 clickCoordinates = new Vector2(screenX, screenY);
        Vector3 position = this.menu.camera.unproject(new Vector3(clickCoordinates.x, clickCoordinates.y, 0.0f));
        if (this.menu.getStartButton().contains(position.x, position.y)) {
            this.menu.clickedStartButton();
        } else if (this.menu.getControlsButton().contains(position.x, position.y)) {
            this.menu.clickedControlsButton();
        } else if (this.menu.getSoundButton().contains(position.x, position.y)) {
            this.menu.clickedSoundButton();
        }
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        Vector2 clickCoordinates = new Vector2(screenX, screenY);
        Vector3 position = this.menu.camera.unproject(new Vector3(clickCoordinates.x, clickCoordinates.y, 0.0f));
        if (this.menu.getStartButton().contains(position.x, position.y)) {
            this.menu.toGameScreen();
        } else if (this.menu.getControlsButton().contains(position.x, position.y)) {
            this.menu.toControlScreen();
        } else if (this.menu.getSoundButton().contains(position.x, position.y)) {
            this.menu.changeSound();
        } else {
            this.menu.idleStartButton();
            this.menu.idleControlsButton();
            this.menu.idleSoundButton();
        }
        return true;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }
}

